static char _tclsvc_c[] =
"$Header: /cvs/tcl/tclsvc/tclsvc.c,v 1.4 1999/06/28 03:15:28 matt Exp $";
/*
 * Copyright (C) 1997-1999 Sensus Consulting Ltd.
 * Matt Newman <matt@sensus.org>
 */
/*
 * Implements Tcl Services under Windows NT.
 *
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <tchar.h>

#define BUILD_tcl
#include "tcl.h"

/* external functions */
extern TCHAR	szService[];

#define SVC_REG_KEY		"SYSTEM\\CurrentControlSet\\Services"
#define SVC_REG_VALUE	"TclScript"

/* internal function prototypes */

/* internal variables */
static TCHAR	szErr[256];
static int		stopRequested = 0;
static Tcl_ThreadId	mainThread;
static int	mainThreadSet = 0;
static Tcl_Event * alerter;

static void
exit_handler(ClientData clientData)
{
    (void)clientData;
    stopRequested = 1;

    ReportStatusToSCMgr( SERVICE_STOPPED, NO_ERROR, 0);
}

VOID
ServiceStart(DWORD argc, LPTSTR *argv)
{
    Tcl_Interp	*interp;
    EXCEPTION_POINTERS	*ep;
    char	keypath[BUFSIZ], buffer[BUFSIZ], *args, *script;
    int		size, exitCode = 0;
    HKEY	key;
    DWORD	result;

    if (!ReportStatusToSCMgr( SERVICE_START_PENDING, NO_ERROR, 5000)) {
	exitCode = 1;
        goto done;
    }
    AddToMessageLog(EVENTLOG_INFORMATION_TYPE, "Service Starting");

    Tcl_FindExecutable(argv[0]);
    interp = Tcl_CreateInterp();

    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    Tcl_Free(args);

    sprintf(buffer, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buffer, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", argv[0], TCL_GLOBAL_ONLY);

    Tcl_SetVar(interp, "tcl_interactive", "0", TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tcl_service", szService, TCL_GLOBAL_ONLY);
    
    if (!ReportStatusToSCMgr( SERVICE_START_PENDING, NO_ERROR, 5000)) {
	exitCode = 1;
        goto done;
    }
    if (Tcl_Init(interp) != TCL_OK) {
	Tcl_Eval(interp, "set errorInfo");
	sprintf(buffer, "Unable to initialize interpreter: %s", interp->result);
        AddToMessageLog(EVENTLOG_ERROR_TYPE, buffer);
	exitCode = 1;
	goto done;
    }
    /*
     * Get script from registry
     */
    strcpy( keypath, SVC_REG_KEY);
    strcat( keypath, "\\");
    strcat( keypath, szService);
    result = RegOpenKeyEx(HKEY_LOCAL_MACHINE, keypath, 0, KEY_READ, &key);
    if (result != ERROR_SUCCESS) {
	sprintf(buffer, "Unable to open registry(HKLM\\%s)", keypath);
        AddToMessageLog(EVENTLOG_ERROR_TYPE, buffer);
	exitCode = 1;
	goto done;
    }

    result = RegQueryValueEx(key, SVC_REG_VALUE, NULL, NULL, NULL, &size);
    if (result != ERROR_SUCCESS) {
	sprintf(buffer, "Unable to read value \"%s\" from HKLM\\%s",
		    SVC_REG_VALUE, keypath);
        AddToMessageLog(EVENTLOG_ERROR_TYPE, buffer);
	exitCode = 1;
	goto done;
    } else {
	Tcl_DString	ds;

	Tcl_DStringInit( &ds);
	Tcl_DStringSetLength(&ds, size);

	result = RegQueryValueEx(key, SVC_REG_VALUE, NULL, NULL,
				(LPBYTE) Tcl_DStringValue(&ds), &size);
	if (result != ERROR_SUCCESS) {
	    Tcl_DStringFree( &ds);
	    sprintf(buffer, "Unable to read value \"%s\" from HKLM\\%s",
				SVC_REG_VALUE, keypath);
	    AddToMessageLog(EVENTLOG_ERROR_TYPE, buffer);
	    exitCode = 1;
	    goto done;
	}
	script = strdup( Tcl_DStringValue(&ds) );
	Tcl_DStringFree( &ds);
    }
    if (!ReportStatusToSCMgr( SERVICE_START_PENDING, NO_ERROR, 5000)) {
	exitCode = 1;
        goto done;
    }
    __try {
    if (Tcl_Eval(interp, script) != TCL_OK) {
	Tcl_Eval(interp, "set errorInfo");
	sprintf(buffer, "Initialization failed: %s", interp->result);
        AddToMessageLog(EVENTLOG_ERROR_TYPE, buffer);
	exitCode = 1;
	goto done;
    }
    /*
     * Now just loop in event loop until service is stopped.
     */
    Tcl_CreateExitHandler(exit_handler, NULL);

    if (!ReportStatusToSCMgr( SERVICE_RUNNING, NO_ERROR, 0)) {
	exitCode = 1;
        goto done;
    }
    mainThread = Tcl_GetCurrentThread();
    alerter = (Tcl_Event *) ckalloc( sizeof (Tcl_Event) );
    mainThreadSet = 1;
    while (stopRequested == 0) {
	Tcl_DoOneEvent(TCL_ALL_EVENTS);
    }
    } /*try*/
    __except (ep = GetExceptionInformation()) {
	EXCEPTION_RECORD *er = ep->ExceptionRecord;
	char buf[BUFSIZ], buf2[BUFSIZ];

	sprintf(buf, "runtime exception: code=0x%x, flags=0x%x, addr=0x%x",
	    er->ExceptionCode, er->ExceptionFlags, er->ExceptionAddress);

	if (er->ExceptionCode == EXCEPTION_ACCESS_VIOLATION) {
	    sprintf(buf2, "\nwhile %s address 0x%x",
		(er->ExceptionInformation[0] == 0 ? "reading from" : "writing to"),
		er->ExceptionInformation[1]);
	    strcat(buf, buf2);
	}
	AddToMessageLog(EVENTLOG_ERROR_TYPE, buf);
	ReportStatusToSCMgr( SERVICE_STOP_PENDING, NO_ERROR, 0);
	ExitProcess(er->ExceptionCode);
	/*NOTREACHED*/
    }
    ReportStatusToSCMgr( SERVICE_STOP_PENDING, NO_ERROR, 0);
    /*
     * Rather than calling exit, invoke the "exit" command so that
     * users can replace "exit" with some other command to do additional
     * cleanup on exit.  The Tcl_Eval call should never return.
     */

done:
    if (exitCode == 0) {
	AddToMessageLog(EVENTLOG_INFORMATION_TYPE, "Service Shutting down");
    } else {
	AddToMessageLog(EVENTLOG_WARNING_TYPE, "Service Exiting");
    }
    sprintf(buffer, "exit %d", exitCode);
    Tcl_Eval(interp, buffer);
}

static int EmptyProc( Tcl_Event *ev, int flags ) { return 1; }
void
ServiceStop(void)
{
    ReportStatusToSCMgr( SERVICE_STOP_PENDING, NO_ERROR, 0);
    stopRequested = 1;
    if (mainThreadSet) {
	mainThreadSet = 0;
	alerter -> proc = EmptyProc;
	Tcl_ThreadQueueEvent(mainThread,alerter,TCL_QUEUE_TAIL);
	Tcl_ThreadAlert(mainThread);
    }
}
